<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <title>Produk Saya</title>
  <link rel="stylesheet" href="/mamber/layui.css">
  <link rel="stylesheet" href="/mamber/common.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">
  <style>
    .common_body {
      background-image: url("/public/site/img/user/balance_bg.png");
      background-repeat: no-repeat;
      background-size: 100% 200px;
    }
    .order_details {
      width: 80px;
      height: 30px;
      background: #FFFFFF;
      border-radius: 100px;
      border: 1px solid #DADBDA;
      font-size: 16px;
      color: #488A31;
      line-height: 30px;
      text-align: center;
    }
    .product_details_status {
      position: absolute;
      top: 0;
      right: 0;
      font-size: 16px;
      color: #ffffff;
      width: 79px;
      height: 24px;
      line-height: 24px;
      background: linear-gradient(90deg, #3E90F2 1%, #1E69C2 100%);
      border-radius: 0 8px 0 8px;
      text-align: center;
    }
    .product_details_status_finish {
      position: absolute;
      top: 0;
      right: 0;
      font-size: 16px;
      color: #848484;
      width: 79px;
      height: 24px;
      line-height: 24px;
      background: #DEDEDE;
      border-radius: 0 8px 0 8px;
      text-align: center;
    }
    .normal {
      color: #FFA320;
    }
    .product_details_name {
      font-weight: 700;
      font-size: 18px;
      color: #333333;
      margin-bottom: 0px !important;
    }
    .param_value {
      margin-top: 15px;
      font-weight: 700;
      font-size: 16px;
      color: #104B91;
      text-align: center;
    }
    .param_label {
      font-size: 12px;
      color: #666666;
      text-align: center;
    }
    .order_time {
      font-size: 13px;
      color: #666666;
    }
    .vip_btn {
      width: 45px;
      margin-left: 5px;
      padding: 0 10px;
      height: 20px;
      border-radius: 10px;
      background: #FFF8E8;
      font-size: 11px;
      color: #FFA320;
      line-height: 20px;
      text-align: left;
    }
  </style>
</head>
<body style="background: #e1be87;">

  <div class="common_header" style="background: none">
    <a href="javascript:history.back(-1)" class="back position">
      <p class="btn"><i class="layui-icon layui-icon-left layui-font-20"></i></p>
      Produk Saya
    </a>
  </div>

  <div class="index_header" style="background: none;margin-top: 20px;">
    <div class="index_menu flex_space">
      <div class="nav nav_active" data-type="all"><p class="title">All</p></div>
      <div class="nav" data-type="1"><p class="title">Introduction</p></div>
      <div class="nav" data-type="2"><p class="title">Completed</p></div>
    </div>
  </div>

  <div class="bill_main" style="margin-top: 10px">
    <div class="bill_bg" id="Balance_details">
      <?php
        use Carbon\Carbon;
        $purchases = \App\Models\Purchase::where('user_id', auth()->id())
          ->with('package')
          ->orderByDesc('id')
          ->get();
      ?>

      <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $package = $purchase->package;
          $startDate = Carbon::parse($purchase->created_at);
          $now = Carbon::now();
          $validity = $package->validity ?? 0;

          $hourly = $purchase->hourly ?? 0;
          $daily = $purchase->daily_income ?? 0;
          $weekly = $purchase->weekly_income ?? 0;

          $incomeType = 'N/A';
          $incomeAmount = 0;
          $earnedIncome = 0;
          $progress = 0;
          $status = 1; // default = Introduction

          if ($hourly > 0) {
            $incomeType = 'Hourly Income';
            $incomeAmount = $hourly;
            $hoursPassed = $startDate->diffInHours($now);
            $earnedIncome = $hoursPassed * $hourly;
            $progress = min(100, ($hoursPassed / ($validity * 24)) * 100);
            $status = 1;
          } elseif ($daily > 0) {
            $incomeType = 'Daily Income';
            $incomeAmount = $daily;
            $daysPassed = $startDate->diffInDays($now);
            $earnedIncome = $daysPassed * $daily;
            $progress = min(100, ($daysPassed / $validity) * 100);
            $status = 1;
          } elseif ($weekly > 0) {
            $incomeType = 'Weekly Income';
            $incomeAmount = $weekly;
            $weeksPassed = floor($startDate->diffInDays($now) / 7);
            $earnedIncome = $weeksPassed * $weekly;
            $progress = min(100, ($weeksPassed / ceil($validity / 7)) * 100);
            $status = 1;
          }

          if ($progress >= 100) {
            $status = 2; // Completed
          }
        ?>

        <div class="product_details_card" data-status="<?php echo e($status); ?>">
          <div class="product_details_item" style="position: relative">
            <div class="product_details_name flex_space">
              <span><?php echo e($package->title ?? 'Unknown Package'); ?></span>
              <div style="display: flex;">
                <div class="vip_btn">
                 <!--img  src="mamber/img/lvl0.svg"-->VIP<?php echo e($package->level ?? 0); ?>

                </div>
                <div class="vip_btn"><?php echo e($validity); ?> days</div>
              </div>
            </div>
            <div class="<?php echo e($status == 2 ? 'product_details_status_finish' : 'product_details_status'); ?>">
              <?php echo e($incomeType); ?>

            </div>
          </div>

          <div class="order_param_content" style="background:#F5F5F5; border-radius:4px; padding:10px 0">
            <div class="layui-row">
              <div class="layui-col-xs4">
                <p class="param_value">₱<?php echo e(number_format($purchase->amount, 2)); ?></p>
                <p class="param_label">Buy Shares</p>
              </div>
              <div class="layui-col-xs4">
                <p class="param_value param_price">₱<?php echo e(number_format($incomeAmount, 2)); ?></p>
                <p class="param_label"><?php echo e($incomeType); ?></p>
              </div>
              <div class="layui-col-xs4">
                <p class="param_value">₱<?php echo e(number_format($earnedIncome, 2)); ?></p>
                <p class="param_label">Total Income</p>
              </div>
            </div>
          </div>

          <div class="flex_space" style="margin-top: 10px">
            <p class="order_time">Order Time: <?php echo e($purchase->created_at); ?></p>
            <a href="#" class="order_details">Details</a>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>

  <script src="/mbtech/layui.js"></script>
  <script>
    const navs = document.querySelectorAll('.nav');
    const cards = document.querySelectorAll('.product_details_card');

    navs.forEach(btn => {
      btn.addEventListener('click', () => {
        navs.forEach(b => b.classList.remove('nav_active'));
        btn.classList.add('nav_active');

        const type = btn.dataset.type;

        cards.forEach(card => {
          const status = card.dataset.status;
          if (type === 'all') {
            card.style.display = 'block';
          } else if (type === status) {
            card.style.display = 'block';
          } else {
            card.style.display = 'none';
          }
        });
      });
    });
  </script>
</body>
</html>
<?php /**PATH /home/zgvdquyg/public_html/resources/views/app/main/ordered.blade.php ENDPATH**/ ?>