<!DOCTYPE html>
<html>
<head> 
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
  <title>Register</title> 
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

  <!-- CSS -->
  <link rel="stylesheet" href="/mamber/layui.css"> 
  <link rel="stylesheet" href="/mamber/common.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">

  <style>
    input { font-family: "Varela Round", sans-serif !important; }

    .loadingClass {
      display: none;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.5);
      color: #fff;
      font-size: 18px;
      z-index: 9999;
    }
    .spinner {
      width: 40px;
      height: 40px;
      border: 4px solid #fff;
      border-top: 4px solid transparent;
      border-radius: 50%;
      animation: spin 0.8s linear infinite;
      margin-bottom: 15px;
    }
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    .toast {
      position: fixed;
      top: 45%;
      left: 50%;
      transform: translate(-50%, -50%);
      background: rgba(0, 0, 0, 0.8);
      color: #fff;
      padding: 10px 20px;
      border-radius: 6px;
      font-size: 16px;
      z-index: 10000;
      display: none;
    }

    .otp-message {
      display: none;
      background-color: #28a745;
      color: white;
      padding: 10px 15px;
      font-size: 14px;
      text-align: center;
    }
  </style>
</head>

<body> 

<!-- ✅ Green OTP banner -->
<div class="otp-message" id="otpMessage">
  Make sure your phone number is correct. To withdraw funds, use the OTP verification code sent to your phone.
</div>

<div class="login_bg"> 
  <div class="main"> 
    <div style="display:flex; width:100%; align-items:center; padding-top:40%; justify-content: center;"> 
      <img src="/mamber/img/logo.svg" style="height:50px; width:50px; border-radius:5px;"> 
    </div> 

    <div class="login_form" style="height: 548px; margin-top:10%; padding: 0px 20px;"> 
      <form action="<?php echo e(url('register')); ?>"  method="post" class="layui-form layui-form-pane" id="registerForm"> 
        <?php echo csrf_field(); ?> 
        <div class="form_container" style="margin-top: 40px;"> 

          <div class="layui-form-item"> 
            <label class="layui-form-label" style="font-weight:bold; height:50px; line-height:32px; width:70px; font-size: 18px;">+63</label> 
            <div class="layui-input-block" style="margin-left:70px;"> 
              <div class="layui-input-wrap">
                <input type="text" name="phone" lay-verify="required" placeholder="Phone Number" autocomplete="off" class="layui-input" style="border-top-right-radius: 10px; border-bottom-right-radius: 10px; height:50px; font-size: 18px; font-weight: 500;">
              </div> 
            </div> 
          </div> 

          <div class="layui-form-item"> 
            <div class="layui-input-wrap"> 
              <input type="password" name="password" lay-verify="required" placeholder="Login Password" autocomplete="off" class="layui-input" style="border-radius: 10px; height:50px; font-size: 18px;" lay-affix="eye">
              <div class="layui-input-affix layui-input-suffix">
                <i class="layui-icon layui-icon-eye-invisible"></i>
              </div> 
            </div> 
          </div> 

          <div class="layui-form-item"> 
            <div class="layui-input-wrap"> 
              <input type="text" name="ref_by" value="<?php echo e($ref_by ?? rand(100000,999999)); ?>" lay-verify="required" placeholder="Invitation Code" autocomplete="off" class="layui-input" style="border-radius: 10px; height:50px; font-size: 18px;"> 
            </div> 
          </div> 

          <div class="layui-form-item"> 
            <div class="layui-row"> 
              <div class="layui-col-xs8"> 
                <div class="layui-input-wrap"> 
                  <input type="number" name="code" id="code" lay-verify="required" placeholder="Verification Code" autocomplete="off" class="layui-input" style="border-radius: 10px; height:50px; font-size: 18px;"> 
                </div> 
              </div> 
              <div class="layui-col-xs4" style="padding-left: 10px;"> 
                <div class="layui-btn layui-btn-fluid layui-btn-primary" style="height: 50px; font-size: 16px; font-weight: bold; color: #3456ff;" id="getCode">
                  Send
                </div> 
              </div> 
            </div> 
          </div> 

          <div style="margin-top: 50px;"> 
            <button class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius login_btn" lay-submit lay-filter="register" style="background:#053c8f; border-radius:10px;">Register Now</button> 
            <a href="/login">
              <button type="button" class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius login_btn" style="background:#f2f2f2; color:#d2aa69;">LOG IN</button>
            </a> 
          </div> 

        </div> 
      </form> 
    </div> 
  </div> 
</div>
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Toast Message -->
<div id="toast" class="toast">Message sent successfully.</div>

<!-- Loading Overlay -->
<div class="loadingClass">
  <div class="spinner"></div>
  <p>Processing...</p>
</div>

<!-- JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/layui.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
layui.use(['form', 'layer'], function(){
  var form = layui.form;
  var layer = layui.layer;

  // Custom validation
  form.verify({
    required: function(value){
      if(!value){
        return 'This field is required';
      }
    }
  });

  // Handle OTP Send
  document.getElementById('getCode').addEventListener('click', function(){
    let phone = document.querySelector('input[name="phone"]').value;
    if (!phone) {
      showToast('Please enter your phone number');
      return;
    }

    document.querySelector('.loadingClass').style.display = 'flex';

    setTimeout(function(){
      document.querySelector('.loadingClass').style.display = 'none';
      const otp = Math.floor(100000 + Math.random() * 900000);
      document.getElementById('code').value = otp;

      document.getElementById('otpMessage').style.display = 'block';
      showToast('Message sent successfully.');
    }, 1000);
  });

  // Submit Form with Loading
  form.on('submit(register)', function(data){
    document.querySelector('.loadingClass').style.display = 'flex';
    return true; // normal form submit
  });

  // Show toast
  function showToast(message) {
    let toast = document.getElementById('toast');
    toast.innerText = message;
    toast.style.display = 'block';
    setTimeout(() => {
      toast.style.display = 'none';
    }, 2000);
  }

});
</script>
</body>
</html>
<?php /**PATH /home/zgvdquyg/public_html/resources/views/app/auth/registration.blade.php ENDPATH**/ ?>