<!DOCTYPE html>
<html>
<head> 
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
  <title>Login</title> 
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  
  <!-- CSS -->
  <link rel="stylesheet" href="/mamber/layui.css"> 
  <link rel="stylesheet" href="/mamber/common.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">

  <!-- Styles -->
  <style>
    input { font-family: "Varela Round", sans-serif !important; }
    .loadingClass {
      display: none;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.5);
      color: #fff;
      font-size: 18px;
      z-index: 9999;
    }
    .spinner {
      width: 40px;
      height: 40px;
      border: 4px solid #fff;
      border-top: 4px solid transparent;
      border-radius: 50%;
      animation: spin 0.8s linear infinite;
      margin-bottom: 15px;
    }
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
  </style>
</head>

<body style="background:none;"> 

<div class="login_bg"> 
  <div class="main"> 
    <!-- Logo -->
    <div style="display:flex; width:100%; align-items:center; padding-top:40%; justify-content: center;"> 
      <img src="/mamber/img/logo.svg" style="height:50px; width:50px; border-radius:5px;"> 
    </div> 

    <!-- Login Form -->
    <div class="login_form" style="margin-top:10%;"> 
      <form action="<?php echo e(url('login')); ?>" method="post" class="layui-form layui-form-pane" id="loginForm"> 
        <?php echo csrf_field(); ?>
        <div class="form_container" style="margin-top: 40px; padding: 0px 20px;"> 

          <!-- Phone Input -->
          <div class="layui-form-item"> 
            <label class="layui-form-label" style="font-weight:bold; height:50px; line-height:32px; width:70px; font-size: 18px;">+63</label> 
            <div class="layui-input-block" style="margin-left:70px;"> 
              <div class="layui-input-wrap">
                <input type="text" name="phone" lay-verify="required" placeholder="Enter your phone number" autocomplete="off" class="layui-input" style="border-top-right-radius: 10px; border-bottom-right-radius: 10px; height:50px; font-size: 18px; font-weight: 500;" lay-affix="clear">
              </div> 
            </div> 
          </div> 

          <!-- Password Input -->
          <div class="layui-form-item"> 
            <div class="layui-input-wrap">
              <input type="password" name="password" lay-verify="required" placeholder="Enter your password" autocomplete="off" class="layui-input" style="border-radius: 10px; height: 50px; font-size: 18px;" lay-affix="eye">
              <div class="layui-input-affix layui-input-suffix">
                <i class="layui-icon layui-icon-eye-invisible"></i>
              </div> 
            </div> 
          </div> 

          <!-- Buttons -->
          <div style="margin-top: 40px;"> 
            <button class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius login_btn" lay-submit lay-filter="loginFilter" style="background:#053c8f; border-radius:10px;">Log In</button> 
            <a href="<?php echo e(url('register')); ?>">
              <button type="button" class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius login_btn" style="background:#f2f2f2; border-radius:10px; color:#d2aa69;">Sign Up</button>
            </a> 
          </div> 

        </div> 
      </form> 
    </div> 
  </div> 
</div> 

<!-- Loading animation -->
<div class="loadingClass">
  <div class="spinner"></div>
  <p>Processing...</p>
</div>

<!-- Optional includes -->
<?php echo $__env->make('loading', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- JS Scripts -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/layui.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Override Chinese texts with English -->
<script>
  layui.use(['form', 'layer'], function(){
    var form = layui.form;
    var layer = layui.layer;

    // Custom verify to override Chinese message
    form.verify({
      required: function(value){
        if(!value){
          return 'This field is required';
        }
      }
    });

    // On form submit
    form.on('submit(loginFilter)', function(data){
      // Show loading spinner
      document.querySelector('.loadingClass').style.display = 'flex';
      
      // Normal form submit
      return true;
    });
  });
</script>

</body>
</html>
<?php /**PATH /home/zgvdquyg/public_html/resources/views/app/auth/login.blade.php ENDPATH**/ ?>