<!DOCTYPE html>
<html>
<head> 
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
  <title>Register_{{env('APP_NAME')}}</title> 
  <link rel="stylesheet" href="/mbtech/layui.css"> 
  <link rel="stylesheet" href="/mbtech/common.css"> 
</head> 
<body class="login_body"> 
<div class="login_bg"> 
 <div class="main"> 
  <div class="logo"></div> 
  <p style="margin:60px 0;text-align: center;font-family: PingFang SC;font-weight: 400;font-size: 24px;color: #FFFFFF;line-height: 24px;">Welcome</p> 
  <div class="login_form position"> 
   <form action="{{url('register')}}" method="post" class="layui-form layui-form-pane register-form"> @csrf
    <div class="form_container"> 
     <div class="layui-form-item"> 
      <label class="layui-form-label">+27</label> 
      <div class="layui-input-block"> 
       <div class="layui-input-wrap">
        <input type="text" name="phone" lay-verify="required" placeholder="Please enter your phone number" autocomplete="off" class="layui-input" lay-affix="clear">
       </div> 
      </div> 
     </div> 
     <div class="layui-form-item"> 
      <div class="layui-input-wrap"> 
       <input type="text" name="nickname" lay-verify="required" placeholder="Please enter nickname" autocomplete="off" class="layui-input" style="border-radius:100px;"> 
      </div> 
     </div> 
     <div class="layui-form-item"> 
      <div class="layui-input-wrap"> 
       <input type="password" name="password" lay-verify="required" placeholder="Please enter password" autocomplete="off" class="layui-input" style="border-radius:100px;" lay-affix="eye">
       <div class="layui-input-affix layui-input-suffix">
        <i class="layui-icon layui-icon-eye-invisible"></i>
       </div> 
      </div> 
     </div> 
     <div class="layui-form-item"> 
      <div class="layui-input-wrap"> 
       <input type="text" name="ref_by" value="{{isset($ref_by) && !empty($ref_by) && $ref_by != null ? $ref_by : rand(0,99999999)}}" lay-verify="required" placeholder="Invitation Code" autocomplete="off" class="layui-input" style="border-radius:100px;"> 
      </div> 
     </div> 
     <div class="layui-form-item"> 
      <div class="layui-row" style="background: none"> 
       <div class="layui-col-xs8"> 
        <div class="layui-input-wrap border_noe"> 
         <input type="number" name="otp" id="otp" lay-verify="required" placeholder="Verification code" autocomplete="off" class="layui-input border_noe" style="border-radius:100px;"> 
        </div> 
       </div> 
       <div class="layui-col-xs4"> 
        <div style="margin-left: 11px;"> 
         <div class="layui-btn layui-btn-fluid layui-btn-primary" style="color: #1A53CF ;border: none;line-height: 50px;" id="getCode" onclick="getOtp()">
          Send
         </div> 
        </div> 
       </div> 
      </div> 
     </div> 
     <div style="margin-top: 20px"> 
      <button class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius login_btn" lay-submit="" lay-filter="register">Register Now</button> 
     </div> 
     <div> 
      <a href="/login" class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius register_btn">Login Now</a> 
     </div> 
    </div> 
   </form> 
  </div> 
 </div> 
</div> 
<div class="loadingClass" style="display: none;">
  <div class="spinner"></div>
  <p id="successMsg">Success...</p>
</div>
@include('loading')
@include('alert-message')
<style>
  .loadingClass {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    color: #fff;
    font-size: 18px;
    z-index: 9999;
  }
  .spinner {
    width: 40px;
    height: 40px;
    border: 4px solid #fff;
    border-top: 4px solid transparent;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
    margin-bottom: 15px;
  }
  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }
</style>
<script>
  function getOtp() {
    let phone = document.querySelector('input[name="phone"]').value;
    if (!phone) {
      showMessage('Please enter a phone number');
      return;
    }
    document.querySelector('.loadingClass').style.display = 'flex';
    setTimeout(function() {
      let otp = Math.floor(1000 + Math.random() * 9000);
      document.querySelector('.loadingClass').style.display = 'none';
      document.querySelector('input[name="otp"]').value = otp;
      showMessage('SMS sent successfully');
    }, 1000);
  }
  function showMessage(msg) {
    let msgBox = document.getElementById('successMsg');
    msgBox.innerText = msg;
    document.querySelector('.loadingClass').style.display = 'flex';
    setTimeout(() => {
      document.querySelector('.loadingClass').style.display = 'none';
    }, 2000);
  }
</script>
</body>
</html>
