<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Package;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PackageController extends Controller
{
    public $route = 'admin.package';

    // List all packages
    public function index()
    {
        $packages = Package::get();
        return view('admin.pages.package.index', compact('packages'));
    }

    // Create or edit a package
    public function create($id = null)
    {
        $data = null;
        if ($id) {
            $data = Package::find($id);
        }
        return view('admin.pages.package.insert', compact('data'));
    }

    // View a specific package
    public function view($id = null)
    {
        $data = Package::find($id);
        return view('admin.pages.package.view', compact('data'));
    }

    // Insert or update package
    public function insert_or_update(Request $request)
    {
        $this->validate($request, [
            'name'                    => 'required',
            'title'                   => 'required',
            'price'                   => 'required|numeric',
            'validity'                => 'required|numeric',
            'commission_with_avg_amount' => 'required|numeric',
            'max_purchase_limit'      => 'required|numeric',
            'is_sold_out'             => 'nullable|boolean',
        ]);

        // If updating an existing package
        if ($request->id) {
            $model = Package::findOrFail($request->id);
            $model->status = $request->status;
        } else {
            // If creating a new package
            $model = new Package();
        }

        // Handle the image upload for the package photo
        $path = uploadImage(false, $request, 'photo', 'upload/package/', 200, 200, $model->photo);
        $model->photo = $path ?? $model->photo;

        // Set package attributes
        $model->name = $request->name;
        $model->title = $request->title;
        $model->price = $request->price;
        //$model->desc = $request->desc;
        $model->validity = $request->validity;
        $model->commission_with_avg_amount = $request->commission_with_avg_amount;
        $model->max_purchase_limit = $request->max_purchase_limit;
        $model->category = $request->category ?? 'fixed';
        $model->is_sold_out = $request->has('is_sold_out') ? $request->is_sold_out : 0;

        // Save the package (either updating or creating)
        $model->save();

        // Return success response
        return redirect()->route($this->route . '.index')->with('success', $request->id ? 'Package Updated Successfully.' : 'Package Created Successfully.');
    }

    // Delete a package
    public function delete($id)
    {
        $model = Package::find($id);

        // Delete the associated image
        deleteImage($model->photo);

        // Delete the package record
        $model->delete();

        // Return success response
        return redirect()->route($this->route . '.index')->with('success', 'Package Deleted Successfully.');
    }
}